set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figure 3

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Standardize TFP 
	foreach var in D1_lnTFPva_oth {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
			
save $path_temp\temp_F3, replace


**2. Set-up of local projections
use $path_temp\temp_F3, clear

	tsset cross year

	* number of lags
	local MaxLPLags 1

	* horizon
	local horizon 5

	***** LHS variable: the response variables
	forvalues i=0/`horizon' {
	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
			gen `var'`i' = (f`i'.`var' - l.`var') * 100
		}
	}

	***** variables to store the impulse response (vector of betas from the LP regressions) and standard errors
	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
		gen b_`var'TFP =.
		gen se_`var'TFP =.
	}

	* set controls in LP regression
		* no maxLPlags of impulse variable (TFP growth)
	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
		local rhs`var'TFP 	l(2/`MaxLPLags').D1_lnTFPva_oth l(2/`MaxLPLags').D1_`var' /*lagged indep & dep var*/
	}

	*set FE 
		local controls country-by-year and sectorgroup
		local FE i.sectorgroup
		
	*set weights
	gen weight_lnEMP = weight_c
	gen weight_lnH_EMP = weight_h_c
	gen weight_lnLAB = weight_h_c
	gen weight_lnVA = weight_VA_c
	gen weight_lnVA_QI = weight_VA_c
	gen weight_lnlaborshare = weight_VA_c 

	foreach var in lnEMP lnH_EMP lnhwage lnLAB lnVA lnVA_QI lnVA_P lnlaborshare {
		local weight`var'	"weight_`var'" 
		}
			
	* set impulse in LP regression
		local lag 1
		gen D1_LP1_EMP = L.D1_lnTFPva_oth
					

**3. Run LP regressions
	* One regression for each horizon of the response 
	forvalues i=0/`horizon' {	
	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {

			* LP regression
			* separately for each of the 8 dependent variables
			xi:areg `var'`i' D1_LP1_EMP `rhs`var'TFP' f(0/`i').D1_lnTFPva_oth D1_lnTFPva_oth `FE' [w=`weight`var''] ///
			   ,  cluster(ic) absorb(ct)
			eststo ols_`var'TFP`i'

			replace b_`var'TFP  = _b[D1_LP1_EMP] if _n == `i'+1
			replace se_`var'TFP = _se[D1_LP1_EMP] if _n == `i'+1
		
		}
	}

	* labels for path tables by dep var
	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
		label var `var'0 "Year 0"
		label var `var'1 "Year 1"
		label var `var'2 "Year 2"
		label var `var'3 "Year 3"
		label var `var'4 "Year 4"
		label var `var'5 "Year 5"
		}
	label var D1_LP1_EMP "TFP growth, lag`lag'"

	eststo clear

	
**4. Make Figure 3
	gen Years = _n-1 if _n <= `horizon' +1

	* zero line
	gen zero = 0 if _n <= `horizon' +1

	***** create confidence bands (in this case 70 and 95%) ****
		scalar sig1 = 0.05	 
		scalar sig2 = 0.30	 

	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
		gen up_`var'TFP = b_`var'TFP  + invnormal(1-sig1/2)*se_`var'TFP  if _n <= (`horizon' + 1)
		gen dn_`var'TFP = b_`var'TFP  - invnormal(1-sig1/2)*se_`var'TFP  if _n <= (`horizon' + 1)
		gen up2_`var'TFP = b_`var'TFP  + invnormal(1-sig2/2)*se_`var'TFP  if _n <= (`horizon' + 1)
		gen dn2_`var'TFP = b_`var'TFP  - invnormal(1-sig2/2)*se_`var'TFP  if _n <= (`horizon' + 1)
		}


	label var lnEMP "Employment"
	label var lnH_EMP "Hours worked"
	label var lnLAB "Wagebill"
	label var lnVA "Nominal VA"
	label var lnVA_QI "Real VA"
	label var lnlaborshare "Labor share"


	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
		local vtext : variable label `var' 
		if `"`vtext'"' == "" local vtext "`var'" 
		
		twoway (rarea up_`var'TFP dn_`var'TFP   Years, ///
		fcolor(gs12) lcolor(white) lpattern(solid)) ///
		(rarea up2_`var'TFP  dn2_`var'TFP   Years, ///
		fcolor(gs10) lcolor(white) lpattern(solid)) ///
		(line b_`var'TFP  Years, lcolor(blue) ///
		lpattern(solid) lwidth(thick)) /// 
		(line zero Years, lcolor(black)), ///
		title("`vtext'", color(black) size(medium)) ///
		ytitle("Estimate", size(medsmall)) xtitle("Year", size(medsmall)) ///
		graphregion(color(white)) plotregion(color(white)) ///
		legend(off) name(`var'TFP, replace)
		graph save    $path_out\LP_TFPown_`var'_lag`lag'.gph, replace
	}	
		
	*Figure 3
	cd $path_out
	graph combine LP_TFPown_lnEMP_lag`lag'.gph LP_TFPown_lnH_EMP_lag`lag'.gph LP_TFPown_lnLAB_lag`lag'.gph LP_TFPown_lnVA_lag`lag'.gph LP_TFPown_lnVA_QI_lag`lag'.gph LP_TFPown_lnlaborshare_lag`lag'.gph, col(3) ///
	title("Own-Industry TFP Effect") plotregion(color(white)) graphregion(color(white)) note("Coefficients are for observed TFP shock in t=-1, rescaled to have a unit standard deviation." "Includes `controls' fixed effects, one lag of TFP and outcome variable growth," "and controls for TFP shocks over over the projection horizon. Bands are 70% and 95% CIs.")
	graph export Fig3.eps, as(eps) replace
	
	*Remove temporary files
	graph drop _all
	foreach var in lnEMP lnH_EMP lnLAB lnVA lnVA_QI lnlaborshare {
	erase $path_out\LP_TFPown_`var'_lag`lag'.gph
	}
	erase $path_temp\temp_F3.dta

